/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.sitevpnpolicy
            .vpnpolicylist.vpnpolicy.entries.filter.lan.lanprefix.lanprefixes;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715.yrtietfinettypes
            .Ipv6Prefix;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of ipv6LanPrefixes.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv6LanPrefixes extends InnerModelObject 
        implements Ipv6LanPrefixes, MultiInstanceObject<Ipv6LanPrefixesKeys> {
    protected Ipv6Prefix lan;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public Ipv6Prefix lan() {
        return lan;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void lan(Ipv6Prefix lan) {
        valueLeafFlags.set(LeafIdentifier.LAN.getLeafIndex());
        this.lan = lan;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lan, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv6LanPrefixes) {
            DefaultIpv6LanPrefixes other = (DefaultIpv6LanPrefixes) obj;
            return
                Objects.equals(lan, other.lan) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("lan=" + lan)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv6LanPrefixes.
     */
    public DefaultIpv6LanPrefixes() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
