/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .transportconstraints;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .transportconstraints.transportconstraints.MulticastTransportConstraints;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .transportconstraints.transportconstraints.UnicastTransportConstraints;

/**
 * Abstraction of an entity which represents the functionality of transportConstraints.
 */
public interface TransportConstraints {

    /**
     * Returns the attribute unicastTransportConstraints.
     *
     * @return unicastTransportConstraints value of unicastTransportConstraints
     */
    UnicastTransportConstraints unicastTransportConstraints();

    /**
     * Returns the attribute multicastTransportConstraints.
     *
     * @return multicastTransportConstraints value of multicastTransportConstraints
     */
    MulticastTransportConstraints multicastTransportConstraints();

    /**
     * Sets the attribute unicastTransportConstraints.
     *
     * @param unicastTransportConstraints value of unicastTransportConstraints
     */
    void unicastTransportConstraints(UnicastTransportConstraints unicastTransportConstraints);

    /**
     * Sets the attribute multicastTransportConstraints.
     *
     * @param multicastTransportConstraints value of multicastTransportConstraints
     */
    void multicastTransportConstraints(MulticastTransportConstraints multicastTransportConstraints);

}
