/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .transportconstraints.transportconstraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .transportconstraints.transportconstraints.unicasttransportconstraints.Constraint;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of unicastTransportConstraints.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultUnicastTransportConstraints extends InnerModelObject implements UnicastTransportConstraints {
    protected List<Constraint> constraint;

    @Override
    public List<Constraint> constraint() {
        return constraint;
    }

    @Override
    public void constraint(List<Constraint> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addToConstraint(Constraint addTo) {
        if (constraint == null) {
            constraint = new ArrayList<>();
        }
        constraint.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(constraint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultUnicastTransportConstraints) {
            DefaultUnicastTransportConstraints other = (DefaultUnicastTransportConstraints) obj;
            return
                Objects.equals(constraint, other.constraint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("constraint=" + constraint)
            .toString();
    }


    /**
     * Creates an instance of defaultUnicastTransportConstraints.
     */
    public DefaultUnicastTransportConstraints() {
    }

}
