/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .vpnservicecloudaccess;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc
            .vpnservicecloudaccess.cloudaccesses.CloudAccess;

/**
 * Abstraction of an entity which represents the functionality of cloudAccesses.
 */
public interface CloudAccesses {

    /**
     * Returns the attribute cloudAccess.
     *
     * @return cloudAccess list of cloudAccess
     */
    List<CloudAccess> cloudAccess();

    /**
     * Sets the attribute cloudAccess.
     *
     * @param cloudAccess list of cloudAccess
     */
    void cloudAccess(List<CloudAccess> cloudAccess);

    /**
     * Adds to the list of cloudAccess.
     *
     * @param addTo value of cloudAccess
     */
    void addToCloudAccess(CloudAccess addTo);

}
