/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.l3vpn.svc.rev20160730.ietfl3vpnsvc.vpnservicecloudaccess.cloudaccesses.cloudaccess.authorizedsites;

import java.lang.Object;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of authorizedSite.
 */
public class AuthorizedSiteKeys implements KeyInfo<DefaultAuthorizedSite> {
    protected Object siteId;
    /**
     * Returns the attribute siteId.
     *
     * @return siteId value of siteId
     */
    public Object siteId() {
        return siteId;
    }

    /**
     * Sets the value to attribute siteId.
     *
     * @param siteId value of siteId
     */
    public void siteId(Object siteId) {
        this.siteId = siteId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(siteId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthorizedSiteKeys) {
            AuthorizedSiteKeys other = (AuthorizedSiteKeys) obj;
            return
                Objects.equals(siteId, other.siteId);
        }
        return false;
    }
}