/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;

/**
 * Abstraction of an entity which represents the functionality of bgpTimer.
 */
public interface BgpTimer {

    /**
     * Identify the leaf of BgpTimer.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents keepAlive.
         */
        KEEPALIVE(1),
        /**
         * Represents holdTime.
         */
        HOLDTIME(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute keepAlive.
     *
     * @return keepAlive value of keepAlive
     */
    int keepAlive();

    /**
     * Returns the attribute holdTime.
     *
     * @return holdTime value of holdTime
     */
    int holdTime();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute keepAlive.
     *
     * @param keepAlive value of keepAlive
     */
    void keepAlive(int keepAlive);

    /**
     * Sets the attribute holdTime.
     *
     * @param holdTime value of holdTime
     */
    void holdTime(int holdTime);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
