/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext.bgpprofile;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of soo.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultSoo extends InnerModelObject implements Soo {
    protected boolean sooEnabled;
    protected String sooValue;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public boolean sooEnabled() {
        return sooEnabled;
    }

    @Override
    public String sooValue() {
        return sooValue;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void sooEnabled(boolean sooEnabled) {
        valueLeafFlags.set(LeafIdentifier.SOOENABLED.getLeafIndex());
        this.sooEnabled = sooEnabled;
    }

    @Override
    public void sooValue(String sooValue) {
        valueLeafFlags.set(LeafIdentifier.SOOVALUE.getLeafIndex());
        this.sooValue = sooValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sooEnabled, sooValue, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSoo) {
            DefaultSoo other = (DefaultSoo) obj;
            return
                Objects.equals(sooEnabled, other.sooEnabled) &&
                Objects.equals(sooValue, other.sooValue) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("sooEnabled=" + sooEnabled)
            .add("sooValue=" + sooValue)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultSoo.
     */
    public DefaultSoo() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
