/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext.classprofile;

import java.lang.String;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of qosClass.
 */
public class QosClassKeys implements KeyInfo<DefaultQosClass> {
    protected String classId;
    /**
     * Returns the attribute classId.
     *
     * @return classId value of classId
     */
    public String classId() {
        return classId;
    }

    /**
     * Sets the value to attribute classId.
     *
     * @param classId value of classId
     */
    public void classId(String classId) {
        this.classId = classId;
    }


    @Override
    public int hashCode() {
        return Objects.hash(classId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QosClassKeys) {
            QosClassKeys other = (QosClassKeys) obj;
            return
                Objects.equals(classId, other.classId);
        }
        return false;
    }
}