/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext.rdrtprofile
            .siterole.customcase.custom;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext
            .extendedcommunity.ExtendedCommunity;

/**
 * Abstraction of an entity which represents the functionality of exportRt.
 */
public interface ExportRt {

    /**
     * Identify the leaf of ExportRt.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents exrtId.
         */
        EXRTID(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute exrtId.
     *
     * @return exrtId value of exrtId
     */
    String exrtId();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute extendedCommunity.
     *
     * @return extendedCommunity value of extendedCommunity
     */
    ExtendedCommunity extendedCommunity();

    /**
     * Sets the attribute exrtId.
     *
     * @param exrtId value of exrtId
     */
    void exrtId(String exrtId);

    /**
     * Sets the attribute extendedCommunity.
     *
     * @param extendedCommunity value of extendedCommunity
     */
    void extendedCommunity(ExtendedCommunity extendedCommunity);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
