/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext
            .requestedtypegrouping.requestedtypeprofile.requestedtypechoice;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext
            .requestedtypegrouping.requestedtypeprofile.RequestedTypeChoice;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.l3vpn.svc.ext.rev20160730.l3vpnsvcext
            .requestedtypegrouping.requestedtypeprofile.requestedtypechoice.physicalcase.Physical;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of physicalCase.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultPhysicalCase extends InnerModelObject implements PhysicalCase {
    protected Physical physical;

    @Override
    public Physical physical() {
        return physical;
    }

    @Override
    public void physical(Physical physical) {
        this.physical = physical;
    }

    @Override
    public int hashCode() {
        return Objects.hash(physical);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPhysicalCase) {
            DefaultPhysicalCase other = (DefaultPhysicalCase) obj;
            return
                Objects.equals(physical, other.physical);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("physical=" + physical)
            .toString();
    }


    /**
     * Creates an instance of defaultPhysicalCase.
     */
    public DefaultPhysicalCase() {
    }

}
