/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .Network;

/**
 * Abstraction of an entity which represents the functionality of networks.
 */
public interface Networks {

    /**
     * Returns the attribute network.
     *
     * @return network list of network
     */
    List<Network> network();

    /**
     * Sets the attribute network.
     *
     * @param network list of network
     */
    void network(List<Network> network);

    /**
     * Adds to the list of network.
     *
     * @param addTo value of network
     */
    void addToNetwork(Network addTo);

}
