/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.networks
            .network.node.SupportingNode;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of node.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultNode extends InnerModelObject 
        implements Node, MultiInstanceObject<NodeKeys> {
    protected NodeId nodeId;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<SupportingNode> supportingNode;

    @Override
    public NodeId nodeId() {
        return nodeId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<SupportingNode> supportingNode() {
        return supportingNode;
    }

    @Override
    public void nodeId(NodeId nodeId) {
        valueLeafFlags.set(LeafIdentifier.NODEID.getLeafIndex());
        this.nodeId = nodeId;
    }

    @Override
    public void supportingNode(List<SupportingNode> supportingNode) {
        this.supportingNode = supportingNode;
    }

    @Override
    public void addToSupportingNode(SupportingNode addTo) {
        if (supportingNode == null) {
            supportingNode = new ArrayList<>();
        }
        supportingNode.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(nodeId, valueLeafFlags, supportingNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultNode) {
            DefaultNode other = (DefaultNode) obj;
            return
                Objects.equals(nodeId, other.nodeId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(supportingNode, other.supportingNode);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("nodeId=" + nodeId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("supportingNode=" + supportingNode)
            .toString();
    }


    /**
     * Creates an instance of defaultNode.
     */
    public DefaultNode() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
