/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.augmentedndnetwork.link;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.rev20151208.yrtietfnetwork.NodeId;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.TpId;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of destination.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultDestination extends InnerModelObject implements Destination {
    protected NodeId destNode;
    protected TpId destTp;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public NodeId destNode() {
        return destNode;
    }

    @Override
    public TpId destTp() {
        return destTp;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void destNode(NodeId destNode) {
        valueLeafFlags.set(LeafIdentifier.DESTNODE.getLeafIndex());
        this.destNode = destNode;
    }

    @Override
    public void destTp(TpId destTp) {
        valueLeafFlags.set(LeafIdentifier.DESTTP.getLeafIndex());
        this.destTp = destTp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(destNode, destTp, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultDestination) {
            DefaultDestination other = (DefaultDestination) obj;
            return
                Objects.equals(destNode, other.destNode) &&
                Objects.equals(destTp, other.destTp) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("destNode=" + destNode)
            .add("destTp=" + destTp)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultDestination.
     */
    public DefaultDestination() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
