/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.node;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.network.topology.rev20151208
            .yrtnetworktopology.networks.network.node.augmentedndnode.Tpoint;

/**
 * Abstraction of an entity which represents the functionality of augmentedNdNode.
 */
public interface AugmentedNdNode {

    /**
     * Returns the attribute tPoint.
     *
     * @return tPoint list of tPoint
     */
    List<Tpoint> tPoint();

    /**
     * Sets the attribute tPoint.
     *
     * @param tPoint list of tPoint
     */
    void tPoint(List<Tpoint> tPoint);

    /**
     * Adds to the list of tPoint.
     *
     * @param addTo value of tPoint
     */
    void addToTpoint(Tpoint addTo);

}
