/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .terecoverystatus.TeRecoveryStatusEnum;
import java.util.Objects;

/**
 * Represents the implementation of teRecoveryStatus.
 */
public final class TeRecoveryStatus {

    private TeRecoveryStatusEnum enumeration;

    /**
     * Creates an instance of teRecoveryStatus.
     */
    private TeRecoveryStatus() {
    }

    /**
     * Creates an instance of enumeration.
     *
     * @param enumeration value of enumeration
     */
    public TeRecoveryStatus(TeRecoveryStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    /**
     * Returns the object of teRecoveryStatus for type enumeration.
     *
     * @param value value of teRecoveryStatus for type enumeration
     * @return teRecoveryStatus for type enumeration
     */
    public static TeRecoveryStatus of(TeRecoveryStatusEnum value) {
        return new TeRecoveryStatus(value);
    }

    /**
     * Returns the attribute enumeration.
     *
     * @return enumeration value of enumeration
     */
    public TeRecoveryStatusEnum enumeration() {
        return enumeration;
    }
    /**
     * Sets the attribute enumeration.
     *
     * @param enumeration value of enumeration
     */
    public void enumeration(TeRecoveryStatusEnum enumeration) {
        this.enumeration = enumeration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(enumeration);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TeRecoveryStatus) {
            TeRecoveryStatus other = (TeRecoveryStatus) obj;
            return
                Objects.equals(enumeration, other.enumeration);
        }
        return false;
    }

    @Override
    public String toString() {
        return enumeration.toString();
    }
    /**
     * Returns the object of teRecoveryStatus fromString input String teRecoveryStatus.
     *
     * @param valInString value of input String
     * @return teRecoveryStatus
     */
    public static TeRecoveryStatus fromString(String valInString) {
        try {
            TeRecoveryStatusEnum tmpVal = TeRecoveryStatusEnum.of(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
