/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdAcceleratedAdvertisement;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdIn;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .performancemetricthrottlecontainer.performancemetricthrottle.ThresholdOut;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of performanceMetricThrottle.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultPerformanceMetricThrottle extends InnerModelObject implements PerformanceMetricThrottle {
    protected long unidirectionalDelayOffset;
    protected long measureInterval;
    protected long advertisementInterval;
    protected long suppressionInterval;
    protected BitSet valueLeafFlags = new BitSet();
    protected ThresholdOut thresholdOut;
    protected ThresholdIn thresholdIn;
    protected ThresholdAcceleratedAdvertisement thresholdAcceleratedAdvertisement;

    @Override
    public long unidirectionalDelayOffset() {
        return unidirectionalDelayOffset;
    }

    @Override
    public long measureInterval() {
        return measureInterval;
    }

    @Override
    public long advertisementInterval() {
        return advertisementInterval;
    }

    @Override
    public long suppressionInterval() {
        return suppressionInterval;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public ThresholdOut thresholdOut() {
        return thresholdOut;
    }

    @Override
    public ThresholdIn thresholdIn() {
        return thresholdIn;
    }

    @Override
    public ThresholdAcceleratedAdvertisement thresholdAcceleratedAdvertisement() {
        return thresholdAcceleratedAdvertisement;
    }

    @Override
    public void unidirectionalDelayOffset(long unidirectionalDelayOffset) {
        valueLeafFlags.set(LeafIdentifier.UNIDIRECTIONALDELAYOFFSET.getLeafIndex());
        this.unidirectionalDelayOffset = unidirectionalDelayOffset;
    }

    @Override
    public void measureInterval(long measureInterval) {
        valueLeafFlags.set(LeafIdentifier.MEASUREINTERVAL.getLeafIndex());
        this.measureInterval = measureInterval;
    }

    @Override
    public void advertisementInterval(long advertisementInterval) {
        valueLeafFlags.set(LeafIdentifier.ADVERTISEMENTINTERVAL.getLeafIndex());
        this.advertisementInterval = advertisementInterval;
    }

    @Override
    public void suppressionInterval(long suppressionInterval) {
        valueLeafFlags.set(LeafIdentifier.SUPPRESSIONINTERVAL.getLeafIndex());
        this.suppressionInterval = suppressionInterval;
    }

    @Override
    public void thresholdOut(ThresholdOut thresholdOut) {
        this.thresholdOut = thresholdOut;
    }

    @Override
    public void thresholdIn(ThresholdIn thresholdIn) {
        this.thresholdIn = thresholdIn;
    }

    @Override
    public void thresholdAcceleratedAdvertisement(ThresholdAcceleratedAdvertisement
                thresholdAcceleratedAdvertisement) {
        this.thresholdAcceleratedAdvertisement = thresholdAcceleratedAdvertisement;
    }

    @Override
    public int hashCode() {
         return Objects.hash(unidirectionalDelayOffset, measureInterval, advertisementInterval, suppressionInterval,
                    valueLeafFlags, thresholdOut, thresholdIn, thresholdAcceleratedAdvertisement);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPerformanceMetricThrottle) {
            DefaultPerformanceMetricThrottle other = (DefaultPerformanceMetricThrottle) obj;
            return
                Objects.equals(unidirectionalDelayOffset, other.unidirectionalDelayOffset) &&
                Objects.equals(measureInterval, other.measureInterval) &&
                Objects.equals(advertisementInterval, other.advertisementInterval) &&
                Objects.equals(suppressionInterval, other.suppressionInterval) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(thresholdOut, other.thresholdOut) &&
                Objects.equals(thresholdIn, other.thresholdIn) &&
                Objects.equals(thresholdAcceleratedAdvertisement, other.thresholdAcceleratedAdvertisement);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("unidirectionalDelayOffset=" + unidirectionalDelayOffset)
            .add("measureInterval=" + measureInterval)
            .add("advertisementInterval=" + advertisementInterval)
            .add("suppressionInterval=" + suppressionInterval)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("thresholdOut=" + thresholdOut)
            .add("thresholdIn=" + thresholdIn)
            .add("thresholdAcceleratedAdvertisement=" + thresholdAcceleratedAdvertisement)
            .toString();
    }


    /**
     * Creates an instance of defaultPerformanceMetricThrottle.
     */
    public DefaultPerformanceMetricThrottle() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
