/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology.telinkinfoattributes.interfaceswitchingcapability;

import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes.SwitchingCapabilities;
import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of interfaceAdjustmentCapability.
 */
public class InterfaceAdjustmentCapabilityKeys implements KeyInfo<DefaultInterfaceAdjustmentCapability> {
    protected Class<? extends SwitchingCapabilities> upperSc;
    /**
     * Returns the attribute upperSc.
     *
     * @return upperSc value of upperSc
     */
    public Class<? extends SwitchingCapabilities> upperSc() {
        return upperSc;
    }

    /**
     * Sets the value to attribute upperSc.
     *
     * @param upperSc value of upperSc
     */
    public void upperSc(Class<? extends SwitchingCapabilities> upperSc) {
        this.upperSc = upperSc;
    }


    @Override
    public int hashCode() {
        return Objects.hash(upperSc);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InterfaceAdjustmentCapabilityKeys) {
            InterfaceAdjustmentCapabilityKeys other = (InterfaceAdjustmentCapabilityKeys) obj;
            return
                Objects.equals(upperSc, other.upperSc);
        }
        return false;
    }
}