/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkstatederived;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeRecoveryStatus;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of recovery.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultRecovery extends InnerModelObject implements Recovery {
    protected TeRecoveryStatus restorationStatus;
    protected TeRecoveryStatus protectionStatus;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public TeRecoveryStatus restorationStatus() {
        return restorationStatus;
    }

    @Override
    public TeRecoveryStatus protectionStatus() {
        return protectionStatus;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void restorationStatus(TeRecoveryStatus restorationStatus) {
        valueLeafFlags.set(LeafIdentifier.RESTORATIONSTATUS.getLeafIndex());
        this.restorationStatus = restorationStatus;
    }

    @Override
    public void protectionStatus(TeRecoveryStatus protectionStatus) {
        valueLeafFlags.set(LeafIdentifier.PROTECTIONSTATUS.getLeafIndex());
        this.protectionStatus = protectionStatus;
    }

    @Override
    public int hashCode() {
        return Objects.hash(restorationStatus, protectionStatus, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRecovery) {
            DefaultRecovery other = (DefaultRecovery) obj;
            return
                Objects.equals(restorationStatus, other.restorationStatus) &&
                Objects.equals(protectionStatus, other.protectionStatus) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("restorationStatus=" + restorationStatus)
            .add("protectionStatus=" + protectionStatus)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultRecovery.
     */
    public DefaultRecovery() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
