/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkunderlayattributes.underlaybackuppath;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .explicitroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of pathElement.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultPathElement extends InnerModelObject 
        implements PathElement, MultiInstanceObject<PathElementKeys> {
    protected long pathElementId;
    protected BitSet valueLeafFlags = new BitSet();
    protected Type type;

    @Override
    public long pathElementId() {
        return pathElementId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public Type type() {
        return type;
    }

    @Override
    public void pathElementId(long pathElementId) {
        valueLeafFlags.set(LeafIdentifier.PATHELEMENTID.getLeafIndex());
        this.pathElementId = pathElementId;
    }

    @Override
    public void type(Type type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(pathElementId, valueLeafFlags, type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPathElement) {
            DefaultPathElement other = (DefaultPathElement) obj;
            return
                Objects.equals(pathElementId, other.pathElementId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(type, other.type);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("pathElementId=" + pathElementId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("type=" + type)
            .toString();
    }


    /**
     * Creates an instance of defaultPathElement.
     */
    public DefaultPathElement() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
