/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeaugment.te;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeOperStatus;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceEnum;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .informationsourceattributes.InformationSourceState;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconfigattributes.TeNodeAttributes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodestatederived.AltInformationSources;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of state.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultState extends InnerModelObject implements State {
    protected TeOperStatus operStatus;
    protected boolean isMultiAccessDr;
    protected InformationSourceEnum informationSource;
    protected List<Object> teNodeTemplate;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<AltInformationSources> altInformationSources;
    protected InformationSourceState informationSourceState;
    protected TeNodeAttributes teNodeAttributes;

    @Override
    public TeOperStatus operStatus() {
        return operStatus;
    }

    @Override
    public boolean isMultiAccessDr() {
        return isMultiAccessDr;
    }

    @Override
    public InformationSourceEnum informationSource() {
        return informationSource;
    }

    @Override
    public List<Object> teNodeTemplate() {
        return teNodeTemplate;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<AltInformationSources> altInformationSources() {
        return altInformationSources;
    }

    @Override
    public InformationSourceState informationSourceState() {
        return informationSourceState;
    }

    @Override
    public TeNodeAttributes teNodeAttributes() {
        return teNodeAttributes;
    }

    @Override
    public void operStatus(TeOperStatus operStatus) {
        valueLeafFlags.set(LeafIdentifier.OPERSTATUS.getLeafIndex());
        this.operStatus = operStatus;
    }

    @Override
    public void isMultiAccessDr(boolean isMultiAccessDr) {
        valueLeafFlags.set(LeafIdentifier.ISMULTIACCESSDR.getLeafIndex());
        this.isMultiAccessDr = isMultiAccessDr;
    }

    @Override
    public void informationSource(InformationSourceEnum informationSource) {
        valueLeafFlags.set(LeafIdentifier.INFORMATIONSOURCE.getLeafIndex());
        this.informationSource = informationSource;
    }

    @Override
    public void teNodeTemplate(List<Object> teNodeTemplate) {
        valueLeafFlags.set(LeafIdentifier.TENODETEMPLATE.getLeafIndex());
        this.teNodeTemplate = teNodeTemplate;
    }

    @Override
    public void altInformationSources(List<AltInformationSources> altInformationSources) {
        this.altInformationSources = altInformationSources;
    }

    @Override
    public void informationSourceState(InformationSourceState informationSourceState) {
        this.informationSourceState = informationSourceState;
    }

    @Override
    public void teNodeAttributes(TeNodeAttributes teNodeAttributes) {
        this.teNodeAttributes = teNodeAttributes;
    }

    @Override
    public void addToTeNodeTemplate(Object addTo) {
        if (teNodeTemplate == null) {
            teNodeTemplate = new ArrayList<>();
        }
        teNodeTemplate.add(addTo);
    }


    @Override
    public void addToAltInformationSources(AltInformationSources addTo) {
        if (altInformationSources == null) {
            altInformationSources = new ArrayList<>();
        }
        altInformationSources.add(addTo);
    }


    @Override
    public int hashCode() {
         return Objects.hash(operStatus, isMultiAccessDr, informationSource, teNodeTemplate, valueLeafFlags,
                    altInformationSources, informationSourceState, teNodeAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultState) {
            DefaultState other = (DefaultState) obj;
            return
                Objects.equals(operStatus, other.operStatus) &&
                Objects.equals(isMultiAccessDr, other.isMultiAccessDr) &&
                Objects.equals(informationSource, other.informationSource) &&
                Objects.equals(teNodeTemplate, other.teNodeTemplate) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(altInformationSources, other.altInformationSources) &&
                Objects.equals(informationSourceState, other.informationSourceState) &&
                Objects.equals(teNodeAttributes, other.teNodeAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("operStatus=" + operStatus)
            .add("isMultiAccessDr=" + isMultiAccessDr)
            .add("informationSource=" + informationSource)
            .add("teNodeTemplate=" + teNodeTemplate)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("altInformationSources=" + altInformationSources)
            .add("informationSourceState=" + informationSourceState)
            .add("teNodeAttributes=" + teNodeAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultState.
     */
    public DefaultState() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
