/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs.connectivitymatrix.From;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tenodeconnectivitymatrixabs.connectivitymatrix.To;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of connectivityMatrix.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultConnectivityMatrix extends InnerModelObject 
        implements ConnectivityMatrix, MultiInstanceObject<ConnectivityMatrixKeys> {
    protected long id;
    protected boolean isAllowed;
    protected BitSet valueLeafFlags = new BitSet();
    protected From from;
    protected To to;

    @Override
    public long id() {
        return id;
    }

    @Override
    public boolean isAllowed() {
        return isAllowed;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public From from() {
        return from;
    }

    @Override
    public To to() {
        return to;
    }

    @Override
    public void id(long id) {
        valueLeafFlags.set(LeafIdentifier.ID.getLeafIndex());
        this.id = id;
    }

    @Override
    public void isAllowed(boolean isAllowed) {
        valueLeafFlags.set(LeafIdentifier.ISALLOWED.getLeafIndex());
        this.isAllowed = isAllowed;
    }

    @Override
    public void from(From from) {
        this.from = from;
    }

    @Override
    public void to(To to) {
        this.to = to;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, isAllowed, valueLeafFlags, from, to);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultConnectivityMatrix) {
            DefaultConnectivityMatrix other = (DefaultConnectivityMatrix) obj;
            return
                Objects.equals(id, other.id) &&
                Objects.equals(isAllowed, other.isAllowed) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(from, other.from) &&
                Objects.equals(to, other.to);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("id=" + id)
            .add("isAllowed=" + isAllowed)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("from=" + from)
            .add("to=" + to)
            .toString();
    }


    /**
     * Creates an instance of defaultConnectivityMatrix.
     */
    public DefaultConnectivityMatrix() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
