/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates.LinkTemplate;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates.NodeTemplate;

/**
 * Abstraction of an entity which represents the functionality of templates.
 */
public interface Templates {

    /**
     * Returns the attribute nodeTemplate.
     *
     * @return nodeTemplate list of nodeTemplate
     */
    List<NodeTemplate> nodeTemplate();

    /**
     * Returns the attribute linkTemplate.
     *
     * @return linkTemplate list of linkTemplate
     */
    List<LinkTemplate> linkTemplate();

    /**
     * Sets the attribute nodeTemplate.
     *
     * @param nodeTemplate list of nodeTemplate
     */
    void nodeTemplate(List<NodeTemplate> nodeTemplate);

    /**
     * Sets the attribute linkTemplate.
     *
     * @param linkTemplate list of linkTemplate
     */
    void linkTemplate(List<LinkTemplate> linkTemplate);

    /**
     * Adds to the list of nodeTemplate.
     *
     * @param addTo value of nodeTemplate
     */
    void addToNodeTemplate(NodeTemplate addTo);

    /**
     * Adds to the list of linkTemplate.
     *
     * @param addTo value of linkTemplate
     */
    void addToLinkTemplate(LinkTemplate addTo);

}
