/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .tetopologiesaugment.te.templates;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .TeTemplateName;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .telinkconfigattributes.TeLinkAttributes;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.topology.rev20160317.yrtietftetopology
            .templateattributes.ReferenceChangePolicyEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of linkTemplate.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultLinkTemplate extends InnerModelObject 
        implements LinkTemplate, MultiInstanceObject<LinkTemplateKeys> {
    protected TeTemplateName name;
    protected int priority;
    protected ReferenceChangePolicyEnum referenceChangePolicy;
    protected BitSet valueLeafFlags = new BitSet();
    protected TeLinkAttributes teLinkAttributes;

    @Override
    public TeTemplateName name() {
        return name;
    }

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public ReferenceChangePolicyEnum referenceChangePolicy() {
        return referenceChangePolicy;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public TeLinkAttributes teLinkAttributes() {
        return teLinkAttributes;
    }

    @Override
    public void name(TeTemplateName name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void priority(int priority) {
        valueLeafFlags.set(LeafIdentifier.PRIORITY.getLeafIndex());
        this.priority = priority;
    }

    @Override
    public void referenceChangePolicy(ReferenceChangePolicyEnum referenceChangePolicy) {
        valueLeafFlags.set(LeafIdentifier.REFERENCECHANGEPOLICY.getLeafIndex());
        this.referenceChangePolicy = referenceChangePolicy;
    }

    @Override
    public void teLinkAttributes(TeLinkAttributes teLinkAttributes) {
        this.teLinkAttributes = teLinkAttributes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, priority, referenceChangePolicy, valueLeafFlags, teLinkAttributes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLinkTemplate) {
            DefaultLinkTemplate other = (DefaultLinkTemplate) obj;
            return
                Objects.equals(name, other.name) &&
                Objects.equals(priority, other.priority) &&
                Objects.equals(referenceChangePolicy, other.referenceChangePolicy) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(teLinkAttributes, other.teLinkAttributes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("priority=" + priority)
            .add("referenceChangePolicy=" + referenceChangePolicy)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("teLinkAttributes=" + teLinkAttributes)
            .toString();
    }


    /**
     * Creates an instance of defaultLinkTemplate.
     */
    public DefaultLinkTemplate() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
