/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .recordroutesubobject.type;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .recordroutesubobject.Type;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ipv4Address.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultIpv4Address extends InnerModelObject implements Ipv4Address {
    protected org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv4Address v4Address;
    protected short v4PrefixLength;
    protected short v4Flags;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv4Address v4Address() {
        return v4Address;
    }

    @Override
    public short v4PrefixLength() {
        return v4PrefixLength;
    }

    @Override
    public short v4Flags() {
        return v4Flags;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void v4Address(org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.inet.types.rev20130715
            .yrtietfinettypes.Ipv4Address v4Address) {
        valueLeafFlags.set(LeafIdentifier.V4ADDRESS.getLeafIndex());
        this.v4Address = v4Address;
    }

    @Override
    public void v4PrefixLength(short v4PrefixLength) {
        valueLeafFlags.set(LeafIdentifier.V4PREFIXLENGTH.getLeafIndex());
        this.v4PrefixLength = v4PrefixLength;
    }

    @Override
    public void v4Flags(short v4Flags) {
        valueLeafFlags.set(LeafIdentifier.V4FLAGS.getLeafIndex());
        this.v4Flags = v4Flags;
    }

    @Override
    public int hashCode() {
        return Objects.hash(v4Address, v4PrefixLength, v4Flags, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultIpv4Address) {
            DefaultIpv4Address other = (DefaultIpv4Address) obj;
            return
                Objects.equals(v4Address, other.v4Address) &&
                Objects.equals(v4PrefixLength, other.v4PrefixLength) &&
                Objects.equals(v4Flags, other.v4Flags) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("v4Address=" + v4Address)
            .add("v4PrefixLength=" + v4PrefixLength)
            .add("v4Flags=" + v4Flags)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultIpv4Address.
     */
    public DefaultIpv4Address() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
