/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.style;

import java.util.List;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.Style;
import org.onosproject.yang.gen.v1.urn.ietf.params.xml.ns.yang.yrt.ietf.te.types.rev20160320.yrtietftetypes
            .tunnelpathsrlgs.tunnelpathsrlgs.style.named.Constraints;

/**
 * Abstraction of an entity which represents the functionality of named.
 */
public interface Named extends Style  {

    /**
     * Returns the attribute constraints.
     *
     * @return constraints list of constraints
     */
    List<Constraints> constraints();

    /**
     * Sets the attribute constraints.
     *
     * @param constraints list of constraints
     */
    void constraints(List<Constraints> constraints);

    /**
     * Adds to the list of constraints.
     *
     * @param addTo value of constraints
     */
    void addToConstraints(Constraints addTo);

}
