/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.topo.rev20140101;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.Node;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ymsTopology.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YmsTopologyOpParam extends InnerModelObject implements YmsTopology {
    protected List<Node> node;
    protected Choice2 choice2;

    @Override
    public List<Node> node() {
        return node;
    }

    @Override
    public Choice2 choice2() {
        return choice2;
    }

    @Override
    public void node(List<Node> node) {
        this.node = node;
    }

    @Override
    public void choice2(Choice2 choice2) {
        this.choice2 = choice2;
    }

    @Override
    public void addToNode(Node addTo) {
        if (node == null) {
            node = new ArrayList<>();
        }
        node.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(node, choice2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YmsTopologyOpParam) {
            YmsTopologyOpParam other = (YmsTopologyOpParam) obj;
            return
                Objects.equals(node, other.node) &&
                Objects.equals(choice2, other.choice2);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("node=" + node)
            .add("choice2=" + choice2)
            .toString();
    }

    /**
     * Creates an instance of ymsTopologyOpParam.
     */
    public YmsTopologyOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}
