/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.choice2;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.Choice2;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of case2a.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCase2a extends InnerModelObject implements Case2a {
    protected String leaf2A1;
    protected String leaf2A2;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String leaf2A1() {
        return leaf2A1;
    }

    @Override
    public String leaf2A2() {
        return leaf2A2;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leaf2A1(String leaf2A1) {
        valueLeafFlags.set(LeafIdentifier.LEAF2A1.getLeafIndex());
        this.leaf2A1 = leaf2A1;
    }

    @Override
    public void leaf2A2(String leaf2A2) {
        valueLeafFlags.set(LeafIdentifier.LEAF2A2.getLeafIndex());
        this.leaf2A2 = leaf2A2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leaf2A1, leaf2A2, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCase2a) {
            DefaultCase2a other = (DefaultCase2a) obj;
            return
                Objects.equals(leaf2A1, other.leaf2A1) &&
                Objects.equals(leaf2A2, other.leaf2A2) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leaf2A1=" + leaf2A1)
            .add("leaf2A2=" + leaf2A2)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultCase2a.
     */
    public DefaultCase2a() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
