/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.node.choice1;

import org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.node.Choice1;
import org.onosproject.yang.gen.v1.urn.topo.rev20140101.ymstopology.node.choice1.case1b.Choice1b;

/**
 * Abstraction of an entity which represents the functionality of case1b.
 */
public interface Case1b extends Choice1  {

    /**
     * Returns the attribute choice1b.
     *
     * @return choice1b value of choice1b
     */
    Choice1b choice1b();

    /**
     * Sets the attribute choice1b.
     *
     * @param choice1b value of choice1b
     */
    void choice1b(Choice1b choice1b);

}
