/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.augment.from.another.file.rev20160826.ytbaugmentfromanotherfile
            .networks.network.node.augmentedndnode;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yms.test.ytb.augment.from.another.file.rev20160826.ytbaugmentfromanotherfile
            .networks.network.node.augmentedndnode.terminationpoint.SupportingTerminationPoint;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of terminationPoint.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultTerminationPoint extends InnerModelObject 
        implements TerminationPoint, MultiInstanceObject<TerminationPointKeys> {
    protected String tpId;
    protected BitSet valueLeafFlags = new BitSet();
    protected List<SupportingTerminationPoint> supportingTerminationPoint;

    @Override
    public String tpId() {
        return tpId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public List<SupportingTerminationPoint> supportingTerminationPoint() {
        return supportingTerminationPoint;
    }

    @Override
    public void tpId(String tpId) {
        valueLeafFlags.set(LeafIdentifier.TPID.getLeafIndex());
        this.tpId = tpId;
    }

    @Override
    public void supportingTerminationPoint(List<SupportingTerminationPoint> supportingTerminationPoint) {
        this.supportingTerminationPoint = supportingTerminationPoint;
    }

    @Override
    public void addToSupportingTerminationPoint(SupportingTerminationPoint addTo) {
        if (supportingTerminationPoint == null) {
            supportingTerminationPoint = new ArrayList<>();
        }
        supportingTerminationPoint.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(tpId, valueLeafFlags, supportingTerminationPoint);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTerminationPoint) {
            DefaultTerminationPoint other = (DefaultTerminationPoint) obj;
            return
                Objects.equals(tpId, other.tpId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags) &&
                Objects.equals(supportingTerminationPoint, other.supportingTerminationPoint);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("tpId=" + tpId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .add("supportingTerminationPoint=" + supportingTerminationPoint)
            .toString();
    }


    /**
     * Creates an instance of defaultTerminationPoint.
     */
    public DefaultTerminationPoint() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
