/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.choice.with.container.and.leaf.yangautoprefixlist.rev20160826
            .ytbchoicewithcontainerandleaflist.contenttest;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yms.test.ytb.choice.with.container.and.leaf.yangautoprefixlist.rev20160826
            .ytbchoicewithcontainerandleaflist.ContentTest;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of listItems.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultListItems extends InnerModelObject implements ListItems {
    protected List<byte[]> listItems;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public List<byte[]> listItems() {
        return listItems;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void listItems(List<byte[]> listItems) {
        valueLeafFlags.set(LeafIdentifier.LISTITEMS.getLeafIndex());
        this.listItems = listItems;
    }

    @Override
    public void addToListItems(byte[] addTo) {
        if (listItems == null) {
            listItems = new ArrayList<>();
        }
        listItems.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(listItems, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultListItems) {
            DefaultListItems other = (DefaultListItems) obj;
            return
                Objects.equals(listItems, other.listItems) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("listItems=" + listItems)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultListItems.
     */
    public DefaultListItems() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
