/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.choice.with.container.and.leaf.yangautoprefixlist.rev20160826
            .ytbchoicewithcontainerandleaflist.contenttest;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yms.test.ytb.choice.with.container.and.leaf.yangautoprefixlist.rev20160826
            .ytbchoicewithcontainerandleaflist.ContentTest;
import org.onosproject.yang.gen.v1.yms.test.ytb.choice.with.container.and.leaf.yangautoprefixlist.rev20160826
            .ytbchoicewithcontainerandleaflist.contenttest.valid.Validlistincase;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of valid.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultValid extends InnerModelObject implements Valid {
    protected List<Validlistincase> validlistincase;

    @Override
    public List<Validlistincase> validlistincase() {
        return validlistincase;
    }

    @Override
    public void validlistincase(List<Validlistincase> validlistincase) {
        this.validlistincase = validlistincase;
    }

    @Override
    public void addToValidlistincase(Validlistincase addTo) {
        if (validlistincase == null) {
            validlistincase = new ArrayList<>();
        }
        validlistincase.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(validlistincase);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultValid) {
            DefaultValid other = (DefaultValid) obj;
            return
                Objects.equals(validlistincase, other.validlistincase);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("validlistincase=" + validlistincase)
            .toString();
    }


    /**
     * Creates an instance of defaultValid.
     */
    public DefaultValid() {
    }

}
