/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.data.type.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yms.test.ytb.data.type.rev20160826.ytbdatatype.EnumDer1;
import org.onosproject.yang.gen.v1.yms.test.ytb.data.type.rev20160826.ytbdatatype.EnumLeafListUnion;
import org.onosproject.yang.gen.v1.yms.test.ytb.data.type.rev20160826.ytbdatatype.UnionEnumUnion;

/**
 * Abstraction of an entity which represents the functionality of ytbDataType.
 */
public interface YtbDataType {

    /**
     * Identify the leaf of YtbDataType.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents yangAutoPrefixEnum.
         */
        YANGAUTOPREFIXENUM(1),
        /**
         * Represents unionEnum.
         */
        UNIONENUM(2),
        /**
         * Represents enumLeafList.
         */
        ENUMLEAFLIST(3),
        /**
         * Represents leafRefEnum.
         */
        LEAFREFENUM(4);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute yangAutoPrefixEnum.
     *
     * @return yangAutoPrefixEnum value of yangAutoPrefixEnum
     */
    EnumDer1 yangAutoPrefixEnum();

    /**
     * Returns the attribute unionEnum.
     *
     * @return unionEnum value of unionEnum
     */
    UnionEnumUnion unionEnum();

    /**
     * Returns the attribute enumLeafList.
     *
     * @return enumLeafList list of enumLeafList
     */
    List<EnumLeafListUnion> enumLeafList();

    /**
     * Returns the attribute leafRefEnum.
     *
     * @return leafRefEnum list of leafRefEnum
     */
    List<EnumDer1> leafRefEnum();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute yangAutoPrefixEnum.
     *
     * @param yangAutoPrefixEnum value of yangAutoPrefixEnum
     */
    void yangAutoPrefixEnum(EnumDer1 yangAutoPrefixEnum);

    /**
     * Sets the attribute unionEnum.
     *
     * @param unionEnum value of unionEnum
     */
    void unionEnum(UnionEnumUnion unionEnum);

    /**
     * Sets the attribute enumLeafList.
     *
     * @param enumLeafList list of enumLeafList
     */
    void enumLeafList(List<EnumLeafListUnion> enumLeafList);

    /**
     * Sets the attribute leafRefEnum.
     *
     * @param leafRefEnum list of leafRefEnum
     */
    void leafRefEnum(List<EnumDer1> leafRefEnum);

    /**
     * Adds to the list of enumLeafList.
     *
     * @param addTo value of enumLeafList
     */
    void addToEnumLeafList(EnumLeafListUnion addTo);

    /**
     * Adds to the list of leafRefEnum.
     *
     * @param addTo value of leafRefEnum
     */
    void addToLeafRefEnum(EnumDer1 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
