/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.data.type.rev20160826.ytbdatatype.enumder2;

/**
 * Represents ENUM data of enumDer2Enum.
 */
public enum EnumDer2Enum {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int enumDer2Enum;
    private String schemaName;

    /**
     * Creates an instance of enumDer2Enum.
     *
     * @param enumDer2Enum value of enumDer2Enum
     */
     EnumDer2Enum(int enumDer2Enum, String schemaName) {
        this.enumDer2Enum = enumDer2Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of enumDer2Enum for.
     *
     * @param value value of enumDer2Enum for
     * @return enumDer2Enum for
     */
    public static EnumDer2Enum of(int value) {
        switch (value) {
            case 10:
                return EnumDer2Enum.TEN;
            case 100:
                return EnumDer2Enum.HUNDRED;
            case 1000:
                return EnumDer2Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of enumDer2Enum for.
     *
     * @param value value of enumDer2Enum for
     * @return enumDer2Enum for
     */
    public static EnumDer2Enum of(String value) {
        switch (value) {
            case "ten":
                return EnumDer2Enum.TEN;
            case "hundred":
                return EnumDer2Enum.HUNDRED;
            case "thousand":
                return EnumDer2Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute enumDer2Enum.
     *
     * @return enumDer2Enum value of enumDer2Enum
     */
    public int enumDer2Enum() {
        return enumDer2Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
