/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.derived.type.with.bits.and.binary.rev20160826;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yms.test.ytb.derived.type.with.bits.and.binary.rev20160826
            .ytbderivedtypewithbitsandbinary.Derivedbinarya;
import org.onosproject.yang.gen.v1.yms.test.ytb.derived.type.with.bits.and.binary.rev20160826
            .ytbderivedtypewithbitsandbinary.Derivedbitsa;
import org.onosproject.yang.gen.v1.yms.test.ytb.derived.type.with.bits.and.binary.rev20160826
            .ytbderivedtypewithbitsandbinary.ForunionUnion;

/**
 * Abstraction of an entity which represents the functionality of ytbDerivedTypeWithBitsAndBinary.
 */
public interface YtbDerivedTypeWithBitsAndBinary {

    /**
     * Identify the leaf of YtbDerivedTypeWithBitsAndBinary.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents forbinary.
         */
        FORBINARY(1),
        /**
         * Represents forbits.
         */
        FORBITS(2),
        /**
         * Represents forunion.
         */
        FORUNION(3),
        /**
         * Represents forbinarylist.
         */
        FORBINARYLIST(4),
        /**
         * Represents forbitslist.
         */
        FORBITSLIST(5);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute forbinary.
     *
     * @return forbinary value of forbinary
     */
    Derivedbinarya forbinary();

    /**
     * Returns the attribute forbits.
     *
     * @return forbits value of forbits
     */
    Derivedbitsa forbits();

    /**
     * Returns the attribute forunion.
     *
     * @return forunion value of forunion
     */
    ForunionUnion forunion();

    /**
     * Returns the attribute forbinarylist.
     *
     * @return forbinarylist list of forbinarylist
     */
    List<Derivedbinarya> forbinarylist();

    /**
     * Returns the attribute forbitslist.
     *
     * @return forbitslist list of forbitslist
     */
    List<Derivedbitsa> forbitslist();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute forbinary.
     *
     * @param forbinary value of forbinary
     */
    void forbinary(Derivedbinarya forbinary);

    /**
     * Sets the attribute forbits.
     *
     * @param forbits value of forbits
     */
    void forbits(Derivedbitsa forbits);

    /**
     * Sets the attribute forunion.
     *
     * @param forunion value of forunion
     */
    void forunion(ForunionUnion forunion);

    /**
     * Sets the attribute forbinarylist.
     *
     * @param forbinarylist list of forbinarylist
     */
    void forbinarylist(List<Derivedbinarya> forbinarylist);

    /**
     * Sets the attribute forbitslist.
     *
     * @param forbitslist list of forbitslist
     */
    void forbitslist(List<Derivedbitsa> forbitslist);

    /**
     * Adds to the list of forbinarylist.
     *
     * @param addTo value of forbinarylist
     */
    void addToForbinarylist(Derivedbinarya addTo);

    /**
     * Adds to the list of forbitslist.
     *
     * @param addTo value of forbitslist
     */
    void addToForbitslist(Derivedbitsa addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
