/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.derived.type.with.bits.and.binary.rev20160826
            .ytbderivedtypewithbitsandbinary.derivedbitsb;

import java.util.BitSet;
import java.util.regex.Pattern;

/**
 * Represents ENUM data of bits.
 */
public enum Bits {

    /**
     * Represents index.
     */
    INDEX(1, "index"),

    /**
     * Represents name.
     */
    NAME(10, "name"),

    /**
     * Represents signature.
     */
    SIGNATURE(100, "signature");

    private int bits;
    private String schemaName;

    /**
     * Creates an instance of bits.
     *
     * @param bits value of bits
     */
     Bits(int bits, String schemaName) {
        this.bits = bits;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(int value) {
        switch (value) {
            case 1:
                return Bits.INDEX;
            case 10:
                return Bits.NAME;
            case 100:
                return Bits.SIGNATURE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of bits for.
     *
     * @param value value of bits for
     * @return bits for
     */
    public static Bits of(String value) {
        switch (value) {
            case "index":
                return Bits.INDEX;
            case "name":
                return Bits.NAME;
            case "signature":
                return Bits.SIGNATURE;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute bits.
     *
     * @return bits value of bits
     */
    public int bits() {
        return bits;
    }

    /**
     * Returns the object of bits fromString input String bits.
     *
     * @param valInString value of input String
     * @return bits
     */
    public static BitSet fromString(String valInString) {
        BitSet tmpVal = new BitSet();
        String[] bitNames = valInString.trim().split(Pattern.quote(" "));
        for (String bitName : bitNames) {
            Bits bits = of(bitName);
            if (bits != null) {
                tmpVal.set(bits.bits());
            }
        }
        if (tmpVal.isEmpty()) {
            throw new IllegalArgumentException("not a valid input element");
        }
        return tmpVal;
    }
    public static String toString(BitSet bits) {
        StringBuilder sBuild = new StringBuilder("");
        if (bits.get(Bits.INDEX.bits())) {
            sBuild.append("index");
            sBuild.append(" ");
        }
        if (bits.get(Bits.NAME.bits())) {
            sBuild.append("name");
            sBuild.append(" ");
        }
        if (bits.get(Bits.SIGNATURE.bits())) {
            sBuild.append("signature");
            sBuild.append(" ");
        }
        return sBuild.toString();
    }
}
