/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.empty.type.rev20160826.ytbemptytype;

import java.util.Objects;

/**
 * Represents the implementation of empType.
 */
public final class EmpType {

    private EmpType2 empType2;

    /**
     * Creates an instance of empType.
     */
    private EmpType() {
    }

    /**
     * Creates an instance of empType2.
     *
     * @param empType2 value of empType2
     */
    public EmpType(EmpType2 empType2) {
        this.empType2 = empType2;
    }

    /**
     * Returns the object of empType for type empType2.
     *
     * @param value value of empType for type empType2
     * @return empType for type empType2
     */
    public static EmpType of(EmpType2 value) {
        return new EmpType(value);
    }

    /**
     * Returns the attribute empType2.
     *
     * @return empType2 value of empType2
     */
    public EmpType2 empType2() {
        return empType2;
    }
    /**
     * Sets the attribute empType2.
     *
     * @param empType2 value of empType2
     */
    public void empType2(EmpType2 empType2) {
        this.empType2 = empType2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(empType2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EmpType) {
            EmpType other = (EmpType) obj;
            return
                Objects.equals(empType2, other.empType2);
        }
        return false;
    }

    @Override
    public String toString() {
        return empType2.toString();
    }
    /**
     * Returns the object of empType fromString input String empType.
     *
     * @param valInString value of input String
     * @return empType
     */
    public static EmpType fromString(String valInString) {
        try {
            EmpType2 tmpVal = EmpType2.fromString(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
