/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.empty.type.rev20160826.ytbemptytype;

import java.util.Objects;

/**
 * Represents the implementation of empType2.
 */
public final class EmpType2 {

    private boolean empty;

    /**
     * Creates an instance of empType2.
     */
    private EmpType2() {
    }

    /**
     * Creates an instance of empty.
     *
     * @param empty value of empty
     */
    public EmpType2(boolean empty) {
        this.empty = empty;
    }

    /**
     * Returns the object of empType2 for type empty.
     *
     * @param value value of empType2 for type empty
     * @return empType2 for type empty
     */
    public static EmpType2 of(boolean value) {
        return new EmpType2(value);
    }

    /**
     * Returns the attribute empty.
     *
     * @return empty value of empty
     */
    public boolean empty() {
        return empty;
    }
    /**
     * Sets the attribute empty.
     *
     * @param empty value of empty
     */
    public void empty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public int hashCode() {
        return Objects.hash(empty);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EmpType2) {
            EmpType2 other = (EmpType2) obj;
            return
                Objects.equals(empty, other.empty);
        }
        return false;
    }

    @Override
    public String toString() {
        return empty ? "true" : "false";
    }
    /**
     * Returns the object of empType2 fromString input String empType2.
     *
     * @param valInString value of input String
     * @return empType2
     */
    public static EmpType2 fromString(String valInString) {
        try {
            boolean tmpVal = Boolean.parseBoolean(valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
