/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.module.with.container.rev20160826;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yms.test.ytb.module.with.container.rev20160826.ytbmodulewithcontainer.Sched;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of ytbModuleWithContainer.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class YtbModuleWithContainerOpParam extends InnerModelObject implements YtbModuleWithContainer {
    protected Sched sched;

    @Override
    public Sched sched() {
        return sched;
    }

    @Override
    public void sched(Sched sched) {
        this.sched = sched;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sched);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof YtbModuleWithContainerOpParam) {
            YtbModuleWithContainerOpParam other = (YtbModuleWithContainerOpParam) obj;
            return
                Objects.equals(sched, other.sched);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("sched=" + sched)
            .toString();
    }

    /**
     * Creates an instance of ytbModuleWithContainerOpParam.
     */
    public YtbModuleWithContainerOpParam() {
    }


    @Override
    public void addAugmentation(InnerModelObject obj) {
    }

    @Override
    public void removeAugmentation(InnerModelObject obj) {
    }

    @Override
    public Map<Class<? extends InnerModelObject>, InnerModelObject> augmentations() {

        return null;
    }

    @Override
    public <T extends InnerModelObject> T augmentation(Class<T> c) {

        return null;
    }
}
