/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.module.with.yangautoprefixlist.rev20160826;

import java.util.List;
import org.onosproject.yang.gen.v1.yms.test.ytb.module.with.yangautoprefixlist.rev20160826.ytbmodulewithlist
            .Ytblistlist;

/**
 * Abstraction of an entity which represents the functionality of ytbModuleWithList.
 */
public interface YtbModuleWithList {

    /**
     * Returns the attribute ytblistlist.
     *
     * @return ytblistlist list of ytblistlist
     */
    List<Ytblistlist> ytblistlist();

    /**
     * Sets the attribute ytblistlist.
     *
     * @param ytblistlist list of ytblistlist
     */
    void ytblistlist(List<Ytblistlist> ytblistlist);

    /**
     * Adds to the list of ytblistlist.
     *
     * @param addTo value of ytblistlist
     */
    void addToYtblistlist(Ytblistlist addTo);

}
