/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.tree.builder.yangautoprefixfor.yangautoprefixlist.having.yangautoprefixlist.rev20160826.modulelistandkeyaugment.modkey.augmentedschmodkey;

import org.onosproject.yang.model.KeyInfo;
import java.util.Objects;

/**
 * Represents the implementation of augListModKey.
 */
public class AugListModKeyKeys implements KeyInfo<DefaultAugListModKey> {
    protected int types;
    /**
     * Returns the attribute types.
     *
     * @return types value of types
     */
    public int types() {
        return types;
    }

    /**
     * Sets the value to attribute types.
     *
     * @param types value of types
     */
    public void types(int types) {
        this.types = types;
    }


    @Override
    public int hashCode() {
        return Objects.hash(types);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AugListModKeyKeys) {
            AugListModKeyKeys other = (AugListModKeyKeys) obj;
            return
                Objects.equals(types, other.types);
        }
        return false;
    }
}