/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yms.test.ytb.tree.builder.yangautoprefixfor.yangautoprefixlist.having
            .yangautoprefixlist.rev20160826.ytbtreebuilderforlisthavinglist;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yms.test.ytb.tree.builder.yangautoprefixfor.yangautoprefixlist.having
            .yangautoprefixlist.rev20160826.ytbtreebuilderforlisthavinglist.carrier.Multiplexes;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of carrier.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultCarrier extends InnerModelObject implements Carrier {
    protected List<Multiplexes> multiplexes;

    @Override
    public List<Multiplexes> multiplexes() {
        return multiplexes;
    }

    @Override
    public void multiplexes(List<Multiplexes> multiplexes) {
        this.multiplexes = multiplexes;
    }

    @Override
    public void addToMultiplexes(Multiplexes addTo) {
        if (multiplexes == null) {
            multiplexes = new ArrayList<>();
        }
        multiplexes.add(addTo);
    }


    @Override
    public int hashCode() {
        return Objects.hash(multiplexes);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultCarrier) {
            DefaultCarrier other = (DefaultCarrier) obj;
            return
                Objects.equals(multiplexes, other.multiplexes);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("multiplexes=" + multiplexes)
            .toString();
    }


    /**
     * Creates an instance of defaultCarrier.
     */
    public DefaultCarrier() {
    }

}
