/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear;

import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.Bear;
import org.onosproject.yang.gen.v1.yrt.choice.yangautoprefixcase.rev20160624.choicecase.snack.sportsarena.bear.addon
            .Snacks;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of addOn.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultAddOn extends InnerModelObject implements AddOn {
    protected Snacks snacks;

    @Override
    public Snacks snacks() {
        return snacks;
    }

    @Override
    public void snacks(Snacks snacks) {
        this.snacks = snacks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(snacks);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultAddOn) {
            DefaultAddOn other = (DefaultAddOn) obj;
            return
                Objects.equals(snacks, other.snacks);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("snacks=" + snacks)
            .toString();
    }


    /**
     * Creates an instance of defaultAddOn.
     */
    public DefaultAddOn() {
    }

}
