/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.food.rev20160624;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrt.food.rev20160624.food.C2;

/**
 * Abstraction of an entity which represents the functionality of food.
 */
public interface Food {

    /**
     * Identify the leaf of Food.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents bool.
         */
        BOOL(1),
        /**
         * Represents yangAutoPrefixBoolean.
         */
        YANGAUTOPREFIXBOOLEAN(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute bool.
     *
     * @return bool value of bool
     */
    boolean bool();

    /**
     * Returns the attribute yangAutoPrefixBoolean.
     *
     * @return yangAutoPrefixBoolean list of yangAutoPrefixBoolean
     */
    List<Boolean> yangAutoPrefixBoolean();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute food.
     *
     * @return food value of food
     */
    org.onosproject.yang.gen.v1.yrt.food.rev20160624.food.Food food();

    /**
     * Returns the attribute c2.
     *
     * @return c2 value of c2
     */
    C2 c2();

    /**
     * Sets the attribute bool.
     *
     * @param bool value of bool
     */
    void bool(boolean bool);

    /**
     * Sets the attribute yangAutoPrefixBoolean.
     *
     * @param yangAutoPrefixBoolean list of yangAutoPrefixBoolean
     */
    void yangAutoPrefixBoolean(List<Boolean> yangAutoPrefixBoolean);

    /**
     * Sets the attribute food.
     *
     * @param food value of food
     */
    void food(org.onosproject.yang.gen.v1.yrt.food.rev20160624.food.Food food);

    /**
     * Sets the attribute c2.
     *
     * @param c2 value of c2
     */
    void c2(C2 c2);

    /**
     * Adds to the list of yangAutoPrefixBoolean.
     *
     * @param addTo value of yangAutoPrefixBoolean
     */
    void addToYangAutoPrefixBoolean(Boolean addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
