/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.logistics.manager.rev20160524.logisticsmanager;

import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.MultiInstanceObject;

/**
 * Represents the implementation of materialSupervisor.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultMaterialSupervisor extends InnerModelObject 
        implements MaterialSupervisor, MultiInstanceObject<MaterialSupervisorKeys> {
    protected String name;
    protected String departmentId;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public String name() {
        return name;
    }

    @Override
    public String departmentId() {
        return departmentId;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void name(String name) {
        valueLeafFlags.set(LeafIdentifier.NAME.getLeafIndex());
        this.name = name;
    }

    @Override
    public void departmentId(String departmentId) {
        valueLeafFlags.set(LeafIdentifier.DEPARTMENTID.getLeafIndex());
        this.departmentId = departmentId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, departmentId, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultMaterialSupervisor) {
            DefaultMaterialSupervisor other = (DefaultMaterialSupervisor) obj;
            return
                Objects.equals(name, other.name) &&
                Objects.equals(departmentId, other.departmentId) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("name=" + name)
            .add("departmentId=" + departmentId)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultMaterialSupervisor.
     */
    public DefaultMaterialSupervisor() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
