/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.logistics.manager.rev20160524.logisticsmanager;

import java.util.BitSet;
import java.util.List;

/**
 * Abstraction of an entity which represents the functionality of purchasingSupervisor.
 */
public interface PurchasingSupervisor {

    /**
     * Identify the leaf of PurchasingSupervisor.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents purchasingSpecialist.
         */
        PURCHASINGSPECIALIST(1),
        /**
         * Represents support.
         */
        SUPPORT(2);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute purchasingSpecialist.
     *
     * @return purchasingSpecialist value of purchasingSpecialist
     */
    String purchasingSpecialist();

    /**
     * Returns the attribute support.
     *
     * @return support list of support
     */
    List<String> support();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Sets the attribute purchasingSpecialist.
     *
     * @param purchasingSpecialist value of purchasingSpecialist
     */
    void purchasingSpecialist(String purchasingSpecialist);

    /**
     * Sets the attribute support.
     *
     * @param support list of support
     */
    void support(List<String> support);

    /**
     * Adds to the list of support.
     *
     * @param addTo value of support
     */
    void addToSupport(String addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
