/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedata.firstlevel;

import java.util.BitSet;
import java.util.List;
import org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedata.Uri;
import org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedata.firstlevel.listinlist.List2;

/**
 * Abstraction of an entity which represents the functionality of listInList.
 */
public interface ListInList {

    /**
     * Identify the leaf of ListInList.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents listKey.
         */
        LISTKEY(1);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute listKey.
     *
     * @return listKey value of listKey
     */
    Uri listKey();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute list2.
     *
     * @return list2 list of list2
     */
    List<List2> list2();

    /**
     * Sets the attribute listKey.
     *
     * @param listKey value of listKey
     */
    void listKey(Uri listKey);

    /**
     * Sets the attribute list2.
     *
     * @param list2 list of list2
     */
    void list2(List<List2> list2);

    /**
     * Adds to the list of list2.
     *
     * @param addTo value of list2
     */
    void addToList2(List2 addTo);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
