/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedata.firstlevel.containerleaflist;

/**
 * Represents ENUM data of leafList2Enum.
 */
public enum LeafList2Enum {

    /**
     * Represents ten.
     */
    TEN(10, "ten"),

    /**
     * Represents hundred.
     */
    HUNDRED(100, "hundred"),

    /**
     * Represents thousand.
     */
    THOUSAND(1000, "thousand");

    private int leafList2Enum;
    private String schemaName;

    /**
     * Creates an instance of leafList2Enum.
     *
     * @param leafList2Enum value of leafList2Enum
     */
     LeafList2Enum(int leafList2Enum, String schemaName) {
        this.leafList2Enum = leafList2Enum;
        this.schemaName = schemaName;
    }

    /**
     * Returns the object of leafList2Enum for.
     *
     * @param value value of leafList2Enum for
     * @return leafList2Enum for
     */
    public static LeafList2Enum of(int value) {
        switch (value) {
            case 10:
                return LeafList2Enum.TEN;
            case 100:
                return LeafList2Enum.HUNDRED;
            case 1000:
                return LeafList2Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the object of leafList2Enum for.
     *
     * @param value value of leafList2Enum for
     * @return leafList2Enum for
     */
    public static LeafList2Enum of(String value) {
        switch (value) {
            case "ten":
                return LeafList2Enum.TEN;
            case "hundred":
                return LeafList2Enum.HUNDRED;
            case "thousand":
                return LeafList2Enum.THOUSAND;
            default :
                throw new IllegalArgumentException("not a valid input element");
        }
    }
    /**
     * Returns the attribute leafList2Enum.
     *
     * @return leafList2Enum value of leafList2Enum
     */
    public int leafList2Enum() {
        return leafList2Enum;
    }


    @Override
    public String toString() {
        return schemaName;
    }
}
