/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedata.uniontypedef;

import java.util.Objects;
import java.util.BitSet;

/**
 * Represents the implementation of unionTypedefUnion.
 */
public final class UnionTypedefUnion {
    private int int32;
    private String string;
    private BitSet setValue = new BitSet();

    /**
     * Creates an instance of unionTypedefUnion.
     */
    private UnionTypedefUnion() {
    }

    /**
     * Creates an instance of int32.
     *
     * @param int32 value of int32
     */
    public UnionTypedefUnion(int int32) {
        setValue.set(0);
        this.int32 = int32;
    }

    /**
     * Creates an instance of string.
     *
     * @param string value of string
     */
    public UnionTypedefUnion(String string) {
        setValue.set(1);
        this.string = string;
    }

    /**
     * Returns the object of unionTypedefUnion for type int32.
     *
     * @param value value of unionTypedefUnion for type int32
     * @return unionTypedefUnion for type int32
     */
    public static UnionTypedefUnion of(int value) {
        return new UnionTypedefUnion(value);
    }

    /**
     * Returns the object of unionTypedefUnion for type string.
     *
     * @param value value of unionTypedefUnion for type string
     * @return unionTypedefUnion for type string
     */
    public static UnionTypedefUnion of(String value) {
        return new UnionTypedefUnion(value);
    }

    /**
     * Returns the attribute int32.
     *
     * @return int32 value of int32
     */
    public int int32() {
        return int32;
    }
    /**
     * Returns the attribute string.
     *
     * @return string value of string
     */
    public String string() {
        return string;
    }
    /**
     * Sets the attribute int32.
     *
     * @param int32 value of int32
     */
    public void int32(int int32) {
        this.int32 = int32;
    }
    /**
     * Sets the attribute string.
     *
     * @param string value of string
     */
    public void string(String string) {
        this.string = string;
    }

    @Override
    public int hashCode() {
        return Objects.hash(int32, string);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnionTypedefUnion) {
            UnionTypedefUnion other = (UnionTypedefUnion) obj;
            return
                Objects.equals(int32, other.int32) &&
                Objects.equals(string, other.string);
        }
        return false;
    }

    @Override
    public String toString() {
        if (setValue.get(0)) {
            return String.valueOf(int32);
        }
        if (setValue.get(1)) {
            return string;
        }
        return null;
    }
    /**
     * Returns the object of unionTypedefUnion fromString input String unionTypedefUnion.
     *
     * @param valInString value of input String
     * @return unionTypedefUnion
     */
    public static UnionTypedefUnion fromString(String valInString) {
        try {
            int tmpVal = Integer.parseInt(valInString);
            return of(tmpVal);
        } catch (Exception e) {
        }
        try {
            String tmpVal = (valInString);
            return of(tmpVal);
        } catch (Exception e) {
            throw new IllegalArgumentException("not a valid input element");
        }
    }
}
