/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.model.converter.model.data.to.resource.data.rev20160826
            .modeldatatoresourcedatainterfile.firstlevel.augmentedschfirstlevel;

import java.math.BigDecimal;
import java.util.BitSet;
import java.util.Objects;
import java.util.StringJoiner;
import org.onosproject.yang.model.InnerModelObject;

/**
 * Represents the implementation of interContainer.
 *
 * <p>
 * valueLeafFlags identify the leafs whose value are explicitly set
 * Applicable in protocol edit and query operation.
 * </p>
 */
public class DefaultInterContainer extends InnerModelObject implements InterContainer {
    protected BigDecimal leafInterAug;
    protected BitSet valueLeafFlags = new BitSet();

    @Override
    public BigDecimal leafInterAug() {
        return leafInterAug;
    }

    @Override
    public BitSet valueLeafFlags() {
        return valueLeafFlags;
    }

    @Override
    public void leafInterAug(BigDecimal leafInterAug) {
        valueLeafFlags.set(LeafIdentifier.LEAFINTERAUG.getLeafIndex());
        this.leafInterAug = leafInterAug;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leafInterAug, valueLeafFlags);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultInterContainer) {
            DefaultInterContainer other = (DefaultInterContainer) obj;
            return
                Objects.equals(leafInterAug, other.leafInterAug) &&
                Objects.equals(valueLeafFlags, other.valueLeafFlags);
        }
        return false;
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", getClass().getSimpleName() +"{", "}")
            .add("leafInterAug=" + leafInterAug)
            .add("valueLeafFlags=" + valueLeafFlags)
            .toString();
    }


    /**
     * Creates an instance of defaultInterContainer.
     */
    public DefaultInterContainer() {
    }


    @Override
    public boolean isLeafValueSet(LeafIdentifier leaf) {
        return valueLeafFlags.get(leaf.getLeafIndex());
    }

}
