/*
 * Copyright 2017-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.yang.gen.v1.yrt.yangautoprefixlist.rev20160624.yangautoprefixlist;

import java.util.BitSet;
import org.onosproject.yang.gen.v1.yrt.yangautoprefixlist.rev20160624.yangautoprefixlist.l1.C1;

/**
 * Abstraction of an entity which represents the functionality of l1.
 */
public interface L1 {

    /**
     * Identify the leaf of L1.
     */
    public enum LeafIdentifier implements org.onosproject.yang.model.LeafIdentifier{
        /**
         * Represents k1.
         */
        K1(1),
        /**
         * Represents k2.
         */
        K2(2),
        /**
         * Represents k3.
         */
        K3(3);

        private int leafIndex;

        public int getLeafIndex() {
            return leafIndex;
        }

        LeafIdentifier(int value) {
            this.leafIndex = value;
        }
    }

    /**
     * Returns the attribute k1.
     *
     * @return k1 value of k1
     */
    String k1();

    /**
     * Returns the attribute k2.
     *
     * @return k2 value of k2
     */
    String k2();

    /**
     * Returns the attribute k3.
     *
     * @return k3 value of k3
     */
    String k3();

    /**
     * Returns the attribute valueLeafFlags.
     *
     * @return valueLeafFlags value of valueLeafFlags
     */
    BitSet valueLeafFlags();

    /**
     * Returns the attribute c1.
     *
     * @return c1 value of c1
     */
    C1 c1();

    /**
     * Sets the attribute k1.
     *
     * @param k1 value of k1
     */
    void k1(String k1);

    /**
     * Sets the attribute k2.
     *
     * @param k2 value of k2
     */
    void k2(String k2);

    /**
     * Sets the attribute k3.
     *
     * @param k3 value of k3
     */
    void k3(String k3);

    /**
     * Sets the attribute c1.
     *
     * @param c1 value of c1
     */
    void c1(C1 c1);


    /**
     * Checks if the leaf value is set.
     *
     * @param leaf leaf whose value status needs to checked
     * @return result of leaf value set in object
     */
    boolean isLeafValueSet(LeafIdentifier leaf);
}
